/**
 * Generate initial array with elements as objects
 * This array will be extended later with elements attributes values
 * like 'position'
 */
const createArrayWithElements = function (elements) {
  elements = elements || document.querySelectorAll('[data-aos]');
  return Array.prototype.map.call(elements, node => ({ node }));
};

export default createArrayWithElements;
